#ifndef CRFEPURDEBUGWINDOW_H
#define CRFEPURDEBUGWINDOW_H

#include <QWidget>
#include <ui_CRfePurDebugWindow.h>

#include <QStandardItemModel>

#include <QrfeTraceModule>

class Application;

class QStandardItemModel;
class QwtPlot;
class QwtPlotHistogram;

class QrfeRfePurReader;

typedef struct {
	double 	frequency;
	short 	rssi;
	bool 	antennaState;
} ReaderData;

class CRfePurDebugWindow : public QWidget, QrfeTraceModule
{
    Q_OBJECT

public:
    CRfePurDebugWindow(Application* app, QWidget *parent = 0);
    ~CRfePurDebugWindow();

protected:
    virtual void showEvent ( QShowEvent * event );
    virtual void hideEvent ( QHideEvent * event );

private slots:
	void readerChanged();
	void notification ( uchar id, const QVariant& value );


private:
	void setHistoColor(QwtPlotHistogram* histo, const QColor &symbolColor);

	void loadReader();
	void unloadReader();

	void updateReaderFrequEntry(QString readerId);
	void checkForCollision();


private:
    Ui::CRfePurDebugWindowClass ui;

    Application* 				m_application;
    QList<QrfeRfePurReader*> 	m_readerList;

	QwtPlot*							m_frequencyPlot;
	QMap<QString, QwtPlotHistogram*>	m_frequencyHistograms;
	QMap<QString, ReaderData > 			m_frequencyData;
	QStandardItemModel					m_frequencyModel;
	QList<QString>						m_frequencyModelReaderIndex;
};

#endif // CRFEPURDEBUGWINDOW_H
